<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Customer Details</title>
<style>
  body { font-family: Arial; padding:20px; }
  .form-container { max-width:400px; margin:0 auto; padding:20px; background:#f9f9f9; border-radius:8px; }
  .form-container input, .form-container select, .form-container textarea { width:100%; padding:10px; margin:8px 0; border:1px solid #ccc; border-radius:6px; }
  .form-container button { padding:10px 15px; border:none; border-radius:6px; background:#007bff; color:white; cursor:pointer; width:100%; }
  .form-container button:hover { background:#0056b3; }
</style>
<h2>Customer Details</h2>
<div class="form-container">
    <label>Name</label>
    <input type="text" id="customerName" placeholder="Customer Name">

    <label>Mobile</label>
    <input type="text" id="customerMobile" placeholder="Mobile Number">

    <label>Address</label>
    <textarea id="customerAddress" placeholder="Address (if delivery)"></textarea>

    <label>Order Note</label>
    <textarea id="orderNote" placeholder="Note for order"></textarea>

    <label>Payment Type</label>
    <select id="paymentType">
        <option value="cash">Cash</option>
        <option value="card">Card</option>
    </select>

    <label>Discount (৳)</label>
    <input type="number" id="discount" value="0" min="0">

    <button id="placeOrderBtn">Place Order</button>
</div>

<script>
document.getElementById('placeOrderBtn').onclick = () => {
    const name = document.getElementById('customerName').value.trim();
    const mobile = document.getElementById('customerMobile').value.trim();
    const address = document.getElementById('customerAddress').value.trim();
    const note = document.getElementById('orderNote').value.trim();
    const payment = document.getElementById('paymentType').value;
    const discount = parseFloat(document.getElementById('discount').value) || 0;

    if(name === '' || mobile === ''){
        alert("Please fill customer name and mobile!");
        return;
    }

    // Get cart from sessionStorage
    const cart = JSON.parse(sessionStorage.getItem('orderCart') || '[]');
    const type = sessionStorage.getItem('orderType') || 'collection';

    if(cart.length === 0){
        alert("Cart is empty!");
        return;
    }

    const orderData = {type, cart, customer:{name,mobile,address,note,payment,discount}};

    fetch('submit_order.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify(orderData)
    })
    .then(res => res.text())
    .then(data => {
        alert("Order Placed!");
        // Clear session storage
        sessionStorage.removeItem('orderCart');
        sessionStorage.removeItem('orderType');

        // Open receipt page
        window.open('receipt.php?orderId=' + data, '_blank');
        window.location.href = 'dashboard.php'; // return to dashboard
    });
};
</script>
