<?php
// collection_editable.php
include "db.php";
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Edit Collection Order</title>
<style>
:root{--accent:#28a745;--muted:#f4f6f8;--danger:#dc3545;--pad:12px}
*{box-sizing:border-box}
body,html{margin:0;padding:0;height:100%;font-family:Arial,Helvetica,sans-serif;background:#f6f8fb}
.order-page{display:flex;height:100vh;gap:0}

/* LEFT - products */
.products-section{flex:2;display:flex;flex-direction:column;border-right:1px solid #e6e9ee}
.products-header{padding:var(--pad);background:#fff;border-bottom:1px solid #e6e9ee;position:sticky;top:0;z-index:5}
.products-header h2{margin:0;font-size:18px}
.products-container{flex:1;overflow:auto;padding:0;display:grid;grid-template-columns:repeat(auto-fill,minmax(120px,1fr));gap:4px;background:var(--muted)}
.product-card{background:#fff;border:1px solid #e6e9ee;border-radius:6px;padding:4px;cursor:pointer;transition:all .12s;display:flex;flex-direction:column;align-items:center;gap:4px;font-size:12px}
.product-card:hover{transform:translateY(-2px);box-shadow:0 4px 12px rgba(33,33,33,0.06)}
.product-card img{width:100%;height:80px;object-fit:cover;border-radius:4px}
.product-card h4{margin:0;font-size:12px;line-height:1.2;text-align:center}
.product-card p{margin:0;color:#333;font-weight:700;font-size:12px}

/* RIGHT - cart */
.cart{flex:1;display:flex;flex-direction:column;background:#fff;min-width:360px;position:relative}
.cart h3{margin:0;padding:var(--pad);background:#fff;border-bottom:1px solid #e6e9ee}
.cart-items-container{flex:1;overflow:auto;padding:12px}
table{width:100%;border-collapse:collapse;font-size:13px}
th,td{text-align:center;padding:8px;border:1px solid #efefef}
th{background:#fafafa}
.qty-controls{display:flex;gap:6px;align-items:center;justify-content:center}
.qty-controls button{width:26px;height:26px;border-radius:6px;border:none;background:#eee;cursor:pointer}
.qty-controls input{width:54px;padding:6px;text-align:center;border:1px solid #ddd;border-radius:6px}
.remove-btn{background:var(--danger);color:#fff;border:none;padding:6px 8px;border-radius:6px;cursor:pointer}

/* CART FOOTER - simplified */
.cart-footer{padding:12px;border-top:1px solid #e6e9ee;background:#fff}
.total-line{display:flex;justify-content:space-between;align-items:center;padding:6px 0;font-size:16px}
#goCheckoutBtn{width:100%;padding:12px;border:none;border-radius:8px;background:var(--accent);color:#fff;font-size:16px;cursor:pointer}

@media(max-width:900px){
  .order-page{flex-direction:column}
  .cart{min-width:unset;height:auto;position:static}
  .products-container{grid-template-columns:repeat(auto-fill,minmax(100px,1fr))}
}
</style>
</head>
<body>

<div class="order-page">
  <!-- LEFT: Products -->
  <div class="products-section">
    <div class="products-header">
      <h2>🛠️ Edit Collection Order</h2>
    </div>

    <div class="products-container" id="productsContainer">
      <?php
      $res = $conn->query("SELECT id, name, price, image FROM products ORDER BY name ASC");
      if ($res && $res->num_rows > 0) {
        while ($row = $res->fetch_assoc()) {
          $img = $row['image'] ? htmlspecialchars($row['image']) : 'no_image.png';
          $name = htmlspecialchars($row['name']);
          $price = number_format(floatval($row['price']),2);
          echo "<div class='product-card' data-id='{$row['id']}' data-name=\"{$name}\" data-price='{$row['price']}'>
                  <img src='uploads/{$img}' alt='{$name}'>
                  <h4>{$name}</h4>
                  <p>৳{$price}</p>
                </div>";
        }
      } else {
        echo "<div style='padding:20px;color:#666'>No products found</div>";
      }
      ?>
    </div>
  </div>

  <!-- RIGHT: Cart -->
  <div class="cart">
    <h3>🛒 Cart</h3>

    <div class="cart-items-container">
      <table id="cartTable">
        <thead>
          <tr>
            <th style="width:36%">Item</th>
            <th style="width:20%">Qty</th>
            <th style="width:18%">Price</th>
            <th style="width:18%">Total</th>
            <th style="width:8%">✖</th>
          </tr>
        </thead>
        <tbody id="cartBody"></tbody>
      </table>
    </div>

    <!-- CART FOOTER SIMPLIFIED -->
    <div class="cart-footer">
      <div class="total-line" style="font-weight:700">
        <div>Final Total</div>
        <div>৳<span id="finalTotal">0.00</span></div>
      </div>
      <div style="margin-top:12px">
        <button id="goCheckoutBtn">💾 Update Collection Order</button>
      </div>
    </div>
  </div>
</div>

<script>
const SERVER_EDIT_ORDER = <?= json_encode($_SESSION['edit_order'] ?? null) ?>;
let cart = [];
const productsContainer = document.getElementById('productsContainer');
const cartBody = document.getElementById('cartBody');
const finalTotalEl = document.getElementById('finalTotal');
const goCheckoutBtn = document.getElementById('goCheckoutBtn');

function money(n){ return parseFloat(n||0).toFixed(2); }
function loadInitialCart(){
  try {
    const ls = localStorage.getItem('editOrderData');
    if(ls){
      const parsed = JSON.parse(ls);
      if(parsed && Array.isArray(parsed.items)){
        cart = parsed.items.map(it=>({
          id:parseInt(it.product_id||it.id||0),
          name:it.product_name||it.name||'',
          price:parseFloat(it.price||0),
          qty:parseInt(it.qty||1)
        }));
        return;
      }
    }
    if(SERVER_EDIT_ORDER && SERVER_EDIT_ORDER.items && Array.isArray(SERVER_EDIT_ORDER.items)){
      cart = SERVER_EDIT_ORDER.items.map(it=>({
        id:parseInt(it.product_id||it.id||0),
        name:it.product_name||it.name||'',
        price:parseFloat(it.price||0),
        qty:parseInt(it.qty||1)
      }));
      return;
    }
    cart=[];
  } catch(e){ console.error('Failed to load initial cart',e); cart=[]; }
}

function addToCart(product){
  const existing = cart.find(i=>i.id===product.id);
  if(existing){ existing.qty+=1; } else { cart.push({ id:product.id, name:product.name, price:parseFloat(product.price||0), qty:1 }); }
  renderCart();
}

function renderCart(){
  cartBody.innerHTML='';
  let sub=0;
  cart.forEach((item,idx)=>{
    const total=item.price*item.qty;
    sub+=total;
    const row=document.createElement('tr');
    row.innerHTML=`
      <td style="text-align:left;padding-left:12px">${escapeHtml(item.name)}</td>
      <td>
        <div class="qty-controls" data-index="${idx}">
          <button class="qty-decrease" title="Decrease">−</button>
          <input type="number" class="qty-input" min="1" value="${item.qty}" />
          <button class="qty-increase" title="Increase">+</button>
        </div>
      </td>
      <td>৳${money(item.price)}</td>
      <td>৳<span class="line-total">${money(total)}</span></td>
      <td><button class="remove-btn" data-index="${idx}">Remove</button></td>
    `;
    cartBody.appendChild(row);
  });
  finalTotalEl.innerText=money(sub);
  attachCartEvents();
}

function attachCartEvents(){
  document.querySelectorAll('.qty-increase').forEach(btn=>{ btn.onclick=()=>{ const idx=parseInt(btn.closest('.qty-controls').dataset.index); cart[idx].qty+=1; renderCart(); }; });
  document.querySelectorAll('.qty-decrease').forEach(btn=>{ btn.onclick=()=>{ const idx=parseInt(btn.closest('.qty-controls').dataset.index); if(cart[idx].qty>1) cart[idx].qty-=1; renderCart(); }; });
  document.querySelectorAll('.qty-input').forEach(inp=>{ inp.onchange=()=>{ const idx=parseInt(inp.closest('.qty-controls').dataset.index); let v=parseInt(inp.value)||1; if(v<1)v=1; cart[idx].qty=v; renderCart(); }; inp.onkeyup=(ev)=>{ if(ev.key==='Enter') inp.dispatchEvent(new Event('change')); }; });
  document.querySelectorAll('.remove-btn').forEach(btn=>{ btn.onclick=()=>{ const idx=parseInt(btn.dataset.index); cart.splice(idx,1); renderCart(); }; });
}

function escapeHtml(str){ if(!str) return ''; return String(str).replace(/[&<>"']/g,m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m])); }

productsContainer.addEventListener('click',function(e){
  let node=e.target;
  while(node && node!==productsContainer){
    if(node.classList && node.classList.contains('product-card')){
      addToCart({ id:parseInt(node.dataset.id), name:node.dataset.name, price:parseFloat(node.dataset.price) });
      return;
    }
    node=node.parentNode;
  }
});

goCheckoutBtn.addEventListener('click',function(){
  if(cart.length===0){ return alert('Cart is empty!'); }
  const payload={
    id:SERVER_EDIT_ORDER?(SERVER_EDIT_ORDER.order_id||SERVER_EDIT_ORDER.id||0):0,
    customer_name:SERVER_EDIT_ORDER?(SERVER_EDIT_ORDER.customer_name||''):'',
    customer_phone:SERVER_EDIT_ORDER?(SERVER_EDIT_ORDER.customer_phone||''):'',
    payment_type:SERVER_EDIT_ORDER?(SERVER_EDIT_ORDER.payment_type||'cash'):'cash',
    items:cart.map(it=>({ product_id:it.id, product_name:it.name, price:it.price, qty:it.qty }))
  };
  localStorage.setItem('editOrderData',JSON.stringify(payload));
  const orderId=payload.id||0;
  window.location.href='collection_checkout_editable.php?edit='+encodeURIComponent(orderId);
});

// Initialize
loadInitialCart();
renderCart();
</script>

</body>
</html>
