<?php
session_start();
include "db.php"; // Keep for session/db consistency
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Collection Checkout</title>
<style>
body, html {
  margin:0; padding:0;
  font-family:Arial, sans-serif;
  background:#f5f5f5; height:100vh;
}
.checkout-page {
  display:flex; height:100vh;
}
/* LEFT FORM */
.customer-section {
  flex:1; background:#fff;
  padding:20px; border-right:1px solid #ddd;
}
.customer-section h2 {
  margin-top:0;
}
.form-group {
  margin-bottom:15px;
}
.form-group label {
  display:block; margin-bottom:6px; font-weight:bold;
}
.form-group input, .form-group select {
  width:100%; padding:10px;
  border:1px solid #ccc; border-radius:6px;
}
/* RIGHT CART */
.cart-section {
  flex:1.5; display:flex; flex-direction:column;
  background:#fff; padding:20px;
}
.cart-section h2 {
  margin-top:0;
}
.cart-list {
  flex:1; overflow-y:auto; margin-bottom:15px;
}
table {
  width:100%; border-collapse:collapse; font-size:14px;
}
table th, table td {
  padding:8px; border:1px solid #ddd; text-align:center;
}
/* Totals */
.totals { margin-top:10px; font-size:15px; }
.totals label { display:inline-block; width:100px; }
.totals input {
  width:120px; padding:6px; margin:5px 0;
  border:1px solid #ccc; border-radius:6px;
  text-align:right;
}
/* Confirm button */
.cart-footer { margin-top:15px; text-align:right; }
.confirm-btn {
  padding:12px 20px; background:#28a745; border:none;
  border-radius:8px; color:#fff; font-size:16px;
  cursor:pointer; transition:0.2s;
}
.confirm-btn:hover { background:#218838; }
/* Responsive */
@media(max-width:768px){
  .checkout-page { flex-direction:column; }
  .customer-section { border-right:none; border-bottom:1px solid #ddd; }
}
</style>
</head>
<body>

<div class="checkout-page">
  <!-- LEFT: Customer Form -->
  <div class="customer-section">
    <h2>Customer Details</h2>
    <div class="form-group">
      <label for="custName">Name (Optional)</label>
      <input type="text" id="custName">
    </div>
    <div class="form-group">
      <label for="custPhone">Mobile (Optional)</label>
      <input type="text" id="custPhone">
    </div>
    <div class="form-group">
      <label for="paymentType">Payment Type</label>
      <select id="paymentType">
        <option value="cash">Cash</option>
        <option value="bank">Bank</option>
      </select>
    </div>
  </div>

  <!-- RIGHT: Cart Details -->
  <div class="cart-section">
    <h2>Order Summary</h2>
    <div class="cart-list">
      <table id="checkoutCart">
        <thead>
          <tr>
            <th>Item</th>
            <th>Qty</th>
            <th>Price</th>
            <th>Total</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>

    <!-- Totals -->
    <div class="totals">
      <p><label>Subtotal:</label> ৳<span id="subtotal">0.00</span></p>
      <p><label>Discount:</label> <input type="number" id="discount" value="0" oninput="updateFinal()"> </p>
      <p><label>Tip:</label> <input type="number" id="tip" value="0" oninput="updateFinal()"> </p>
      <p><b><label>Final Total:</label> ৳<span id="finalTotal">0.00</span></b></p>
    </div>

    <!-- Confirm -->
    <div class="cart-footer">
      <button class="confirm-btn" onclick="confirmOrder()">✅ Confirm Order</button>
    </div>
  </div>
</div>

<script>
// Load cart data from localStorage
let cart = JSON.parse(localStorage.getItem("collectionCart")) || [];
renderCheckout();

function renderCheckout(){
  let tbody = document.querySelector("#checkoutCart tbody");
  tbody.innerHTML = "";
  let subtotal = 0;
  cart.forEach(item=>{
    let total = item.qty * item.price;
    subtotal += total;
    let row = document.createElement("tr");
    row.innerHTML = `
      <td>${item.name}</td>
      <td>${item.qty}</td>
      <td>৳${item.price.toFixed(2)}</td>
      <td>৳${total.toFixed(2)}</td>
    `;
    tbody.appendChild(row);
  });
  document.getElementById("subtotal").innerText = subtotal.toFixed(2);
  updateFinal();
}

function updateFinal(){
  let subtotal = parseFloat(document.getElementById("subtotal").innerText) || 0;
  let discount = parseFloat(document.getElementById("discount").value) || 0;
  let tip = parseFloat(document.getElementById("tip").value) || 0;
  let final = subtotal - discount + tip;
  document.getElementById("finalTotal").innerText = final.toFixed(2);
}

async function confirmOrder(){
  if (cart.length === 0) {
    alert("🛒 No items in cart!");
    return;
  }

  let orderData = {
    name: document.getElementById("custName").value,
    phone: document.getElementById("custPhone").value,
    payment: document.getElementById("paymentType").value,
    cart: cart,
    subtotal: parseFloat(document.getElementById("subtotal").innerText),
    discount: parseFloat(document.getElementById("discount").value) || 0,
    tip: parseFloat(document.getElementById("tip").value) || 0,
    finalTotal: parseFloat(document.getElementById("finalTotal").innerText)
  };

  // Save order to database
  let res = await fetch("save_collection_order.php", {
    method: "POST",
    headers: {"Content-Type":"application/json"},
    body: JSON.stringify(orderData)
  });

  let result = await res.json();

  if(result.success){
    // Clear cart
    localStorage.removeItem("collectionCart");
    // Print then redirect automatically after print
    window.location.href = "print_collection.php?id=" + result.order_id + "&redirect=dashboard";
  } else {
    alert("❌ Error saving order: " + result.message);
  }
}
</script>

</body>
</html>
