<?php
session_start();
include "db.php";

// 🔹 Check if we're editing an order (edit=ID)
$editOrder = null;
if (isset($_GET['edit']) && isset($_SESSION['edit_order'])) {
    $editOrder = $_SESSION['edit_order'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Collection Order</title>

<script>
document.addEventListener("DOMContentLoaded", () => {
    // ✅ If PHP passed an editOrder session, preload cart
    <?php if ($editOrder): ?>
        const order = <?= json_encode($editOrder, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>;
        window.cart = order.items.map(it => ({
            id: parseInt(it.product_id),
            name: it.product_name,
            price: parseFloat(it.price),
            qty: parseInt(it.qty)
        }));
        if (typeof updateCartTable === "function") updateCartTable();

        // ✅ Optionally fill customer info (if your checkout or form uses it)
        localStorage.setItem("editOrderCustomerName", order.customer_name);
        localStorage.setItem("editOrderCustomerPhone", order.customer_phone);
        localStorage.setItem("editOrderId", order.order_id);
    <?php else: ?>
        window.cart = [];
    <?php endif; ?>
});
</script>

<style>
body, html { margin: 0; padding: 0; height: 100%; font-family: Arial, sans-serif; }
.order-page { display: flex; height: 100vh; }
/* LEFT SIDE: Products scroll */
.products-section { flex: 2; display: flex; flex-direction: column; border-right: 1px solid #ddd; overflow: hidden; }
.products-header { padding: 12px; background: #f8f8f8; border-bottom: 1px solid #ddd; position: sticky; top: 0; z-index: 5; }
/* ✅ Scroll only products */
.products-container { flex: 1; overflow-y: auto; padding: 10px; display: grid; grid-template-columns: repeat(5, 1fr); gap: 10px; }
.product-card { border: 1px solid #ddd; padding: 6px; border-radius: 6px; text-align: center; cursor: pointer; background: #fff; transition: 0.2s; font-size: 13px; }
.product-card:hover { background: #f1f1f1; }
.product-card img { width: 100%; height: 80px; object-fit: cover; border-radius: 4px; margin-bottom: 4px; }
/* RIGHT SIDE: Cart fixed */
.cart { flex: 1; display: flex; flex-direction: column; background: #fafafa; border-left: 1px solid #ddd; height: 100vh; position: sticky; top: 0; padding: 12px; }
.cart h3 { margin: 0 0 10px; }
.cart-items-container { flex: 1; overflow-y: auto; margin-bottom: 12px; }
.cart-items-container table { width: 100%; border-collapse: collapse; font-size: 13px; }
.cart-items-container th, .cart-items-container td { border: 1px solid #ccc; padding: 5px; text-align: center; }
.cart-footer { margin-top: auto; padding-top: 8px; border-top: 1px solid #ddd; background: #fff; }
button { padding: 10px 16px; border: none; border-radius: 6px; cursor: pointer; }
#goCheckoutBtn { background: #28a745; color: white; width: 100%; font-size: 15px; }
#goCheckoutBtn:hover { background: #218838; }
/* Responsive */
@media (max-width: 1100px) { .products-container { grid-template-columns: repeat(4, 1fr); } }
@media (max-width: 900px) {
    .order-page { flex-direction: column; }
    .products-section { flex: none; height: 50vh; }
    .cart { position: relative; flex: none; height: 50vh; }
    .products-container { grid-template-columns: repeat(3, 1fr); }
}
@media (max-width: 600px) { .products-container { grid-template-columns: repeat(2, 1fr); } }


//new
body, html {
  margin: 0;
  padding: 0;
  height: 100%;
  font-family: Arial, sans-serif;
}

.order-page {
  display: flex;
  height: 100vh;
}

/* LEFT SIDE: Products */
.products-section {
  flex: 2;
  display: flex;
  flex-direction: column;
  border-right: 1px solid #ddd;
  overflow: hidden;
}

.products-header {
  padding: 8px 10px;
  background: #f8f8f8;
  border-bottom: 1px solid #ddd;
  position: sticky;
  top: 0;
  z-index: 5;
}

/* ✅ Compact product grid */
.products-container {
  flex: 1;
  overflow-y: auto;
  padding: 6px;
  display: grid;
  grid-template-columns: repeat(6, 1fr);
  gap: 6px;
}

/* ✅ Compact product cards */
.product-card {
  border: 1px solid #ddd;
  border-radius: 4px;
  background: #fff;
  cursor: pointer;
  transition: 0.2s;
  font-size: 12px;
  padding: 3px;
}

.product-card:hover {
  background: #f1f1f1;
}

/* ✅ Smaller image */
.product-card img {
  width: 100%;
  height: 65px;
  object-fit: cover;
  border-radius: 4px;
  margin-bottom: 2px;
}

/* ✅ Tighten spacing for name & price */
.product-card h4 {
  font-size: 12px;
  margin: 0;
  line-height: 1.2;
}

.product-card p {
  font-size: 12px;
  margin: 2px 0 0 0;
  font-weight: bold;
  color: #333;
}

/* RIGHT SIDE: Cart */
.cart {
  flex: 1;
  display: flex;
  flex-direction: column;
  background: #fafafa;
  border-left: 1px solid #ddd;
  height: 100vh;
  position: sticky;
  top: 0;
  padding: 10px;
}

.cart h3 {
  margin: 0 0 10px;
}

.cart-items-container {
  flex: 1;
  overflow-y: auto;
  margin-bottom: 10px;
}

.cart-items-container table {
  width: 100%;
  border-collapse: collapse;
  font-size: 13px;
}

.cart-items-container th,
.cart-items-container td {
  border: 1px solid #ccc;
  padding: 5px;
  text-align: center;
}

.cart-footer {
  margin-top: auto;
  padding-top: 6px;
  border-top: 1px solid #ddd;
  background: #fff;
}

button {
  padding: 8px 14px;
  border: none;
  border-radius: 6px;
  cursor: pointer;
}

#goCheckoutBtn {
  background: #28a745;
  color: white;
  width: 100%;
  font-size: 14px;
}

#goCheckoutBtn:hover {
  background: #218838;
}

/* ✅ Responsive tweaks */
@media (max-width: 1100px) {
  .products-container { grid-template-columns: repeat(5, 1fr); }
}

@media (max-width: 900px) {
  .order-page { flex-direction: column; }
  .products-section { flex: none; height: 50vh; }
  .cart { position: relative; flex: none; height: 50vh; }
  .products-container { grid-template-columns: repeat(4, 1fr); }
}

@media (max-width: 600px) {
  .products-container { grid-template-columns: repeat(3, 1fr); }
}


</style>
</head>

<body>
<div class="order-page">
    <!-- LEFT: Products -->
    <div class="products-section">
        <div class="products-header">
            <h2>Collection Order <?= $editOrder ? "(Editing #".$editOrder['order_id'].")" : "" ?></h2>
        </div>
        <div class="products-container">
            <?php
            $res = $conn->query("SELECT id, name, price, image FROM products");
            while($row = $res->fetch_assoc()){
                $img = $row['image'] ? $row['image'] : 'no_image.png';
                echo "
                <div class='product-card' data-id='{$row['id']}' data-name='{$row['name']}' data-price='{$row['price']}'>
                    <img src='uploads/{$img}' alt='{$row['name']}'>
                    <h4>{$row['name']}</h4>
                    <p>৳".number_format($row['price'],2)."</p>
                </div>
                ";
            }
            ?>
        </div>
    </div>

    <!-- RIGHT: Cart -->
    <div class="cart">
        <h3>🛒 Cart</h3>
        <div class="cart-items-container">
            <table id="cartTable">
                <thead>
                    <tr><th>Item</th><th>Qty</th><th>Price</th><th>Total</th><th>❌</th></tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
        <div class="cart-footer">
            <h3>Total: ৳<span id="grandTotal">0.00</span></h3>
            <button id="goCheckoutBtn"><?= $editOrder ? "Update Order" : "Submit Collection Order" ?></button>
        </div>
    </div>
</div>

<script src="order_collection.js"></script>
<script>
initCollectionPage();

// ✅ Checkout button (save cart and go to checkout)
document.getElementById("goCheckoutBtn").onclick = function() {
    localStorage.setItem("collectionCart", JSON.stringify(window.cart || []));
    if (typeof loadPage === "function") {
        loadPage("collection_checkout.php");
    } else {
        window.location.href = "collection_checkout.php";
    }
};
</script>



</body>
</html>
