<?php
// $host = "localhost";
// $user = "root";
// $pass = "";
// $db   = "restaurant_pos";

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";
include "db.php";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) die("DB Connection Error: " . $conn->connect_error);

$table = intval($_GET['table'] ?? 0);
$type  = $_GET['type'] ?? 'dinein';

// ✅ Fetch cart items for this table
$sqlItems = "SELECT * FROM cart_items WHERE table_no=?";
$stmtItems = $conn->prepare($sqlItems);
$stmtItems->bind_param("i", $table);
$stmtItems->execute();
$itemsRes = $stmtItems->get_result();

$items = [];
$grand_total = 0;
while ($row = $itemsRes->fetch_assoc()) {
    $items[] = $row;
    $grand_total += $row['total'];
}
$stmtItems->close();

if (empty($items)) {
    echo "<h2>No active cart items for this table.</h2>";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Checkout</title>
  <style>
    body { font-family: Arial, sans-serif; background: #f1f3f6; margin: 0; padding: 20px; }
    .checkout-wrapper { display: flex; gap: 20px; max-width: 1200px; margin: auto; flex-wrap: wrap; }
    .card { background: #fff; border-radius: 10px; padding: 20px; box-shadow: 0 3px 12px rgba(0,0,0,0.1); flex: 1; min-width: 300px; }
    h2 { margin-bottom: 20px; color: #333; text-align: center; }
    h3 { margin-bottom: 12px; color: #444; }
    table { width: 100%; border-collapse: collapse; margin-bottom: 15px; }
    th, td { padding: 10px; border: 1px solid #ddd; text-align: center; font-size: 14px; }
    th { background: #f8f9fa; }
    .form-group { margin-bottom: 15px; }
    label { font-weight: bold; display: block; margin-bottom: 6px; color: #444; }
    input, select, textarea { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 6px; font-size: 14px; }
    textarea { resize: vertical; }
    .totals-box { margin-top: 20px; padding: 15px; border-radius: 8px; background: #f9fbfd; border: 1px solid #e1e4e8; }
    .totals-box .row { display: flex; justify-content: space-between; margin-bottom: 10px; font-size: 15px; }
    .totals-box .row strong { color: #222; }
    .totals-box input { max-width: 120px; text-align: right; }
    .grand-total { font-size: 18px; font-weight: bold; color: #007bff; border-top: 1px solid #ddd; padding-top: 10px; margin-top: 10px; }
    button { background: #007bff; color: #fff; padding: 14px; width: 100%; border: none; border-radius: 8px; font-size: 16px; cursor: pointer; transition: 0.3s; margin-top: 15px; }
    button:hover { background: #0056b3; }
    @media(max-width: 768px) { .checkout-wrapper { flex-direction: column; } }
  </style>
</head>
<body>
  <h2>Checkout (Table <?= $table ?>)</h2>
  <form id="checkoutForm" class="checkout-wrapper">

    <!-- LEFT: Customer Info -->
    <div class="card">
      <h3>Customer Information</h3>
      <input type="hidden" name="table" value="<?= $table ?>">
      <input type="hidden" name="type" value="<?= $type ?>">
      <input type="hidden" name="grand_total" value="<?= $grand_total ?>">

      <div class="form-group">
        <label>Customer Name</label>
        <input type="text" name="customer_name">
      </div>
      <div class="form-group">
        <label>Mobile</label>
        <input type="text" name="customer_phone">

      </div>
      <div class="form-group">
        <label>Address</label>
        <textarea name="customer_address"></textarea>
      </div>
      <div class="form-group">
        <label>Order Note</label>
        <textarea name="order_note"></textarea>
      </div>
      <div class="form-group">
        <label>Payment Type <span style="color:red">*</span></label>
        <select name="payment_type" required>
          <option value="">-- Select Payment --</option>
          <option value="cash">Cash</option>
          <option value="bank">Bank</option>
        </select>
      </div>
    </div>

    <!-- RIGHT: Order Summary -->
    <div class="card">
      <h3>Order Summary</h3>
      <table>
        <thead>
          <tr><th>Product</th><th>Qty</th><th>Price</th><th>Total</th></tr>
        </thead>
        <tbody>
          <?php foreach($items as $item): ?>
          <tr>
            <td><?= htmlspecialchars($item['product_name']) ?></td>
            <td><?= $item['qty'] ?></td>
            <td>৳<?= number_format($item['price'],2) ?></td>
            <td>৳<?= number_format($item['total'],2) ?></td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>

      <div class="totals-box">
        <div class="row"><span>Grand Total</span> <strong>৳<span id="grandTotal"><?= number_format($grand_total,2) ?></span></strong></div>
        <div class="row"><span>Discount</span> <input type="number" step="0.01" name="discount" id="discount" value="0"></div>
        <div class="row"><span>Tips</span> <input type="number" step="0.01" name="tips" id="tips" value="0"></div>
        <div class="row"><span>Sub Total</span> <strong>৳<span id="subTotal"><?= number_format($grand_total,2) ?></span></strong></div>
        <div class="grand-total">Payable: ৳<span id="payable"><?= number_format($grand_total,2) ?></span></div>
      </div>

      <button type="submit">Complete Checkout</button>
    </div>
  </form>

  <script>
  const discountInput = document.getElementById("discount");
  const tipsInput = document.getElementById("tips");
  const subTotalLabel = document.getElementById("subTotal");
  const payableLabel = document.getElementById("payable");
  const grandTotal = parseFloat(document.getElementById("grandTotal").innerText);

  function updateTotals() {
    const discount = parseFloat(discountInput.value) || 0;
    const tips = parseFloat(tipsInput.value) || 0;
    const subtotal = Math.max(0, grandTotal - discount);
    const payable = Math.max(0, subtotal + tips);
    subTotalLabel.innerText = subtotal.toFixed(2);
    payableLabel.innerText = payable.toFixed(2);
  }
  discountInput.addEventListener("input", updateTotals);
  tipsInput.addEventListener("input", updateTotals);

  // ✅ Submit checkout
  document.getElementById("checkoutForm").addEventListener("submit", function(e) {
    e.preventDefault();
    const formData = new FormData(this);
    const data = {};
    formData.forEach((value, key) => data[key] = value);

    fetch("finalize_checkout.php", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify(data)
    })
    .then(res => res.json())
    .then(json => {
      if (json.status === "success") {
        sessionStorage.clear();
        if (window.cart) window.cart = [];
        if (json.receipt_url) window.open(json.receipt_url, "_blank");
        setTimeout(() => window.location.href = "dashboard.php", 1000);
      } else {
        alert("❌ Checkout failed: " + json.message);
      }
    })
    .catch(err => {
      console.error("❌ Checkout error:", err);
      alert("Failed to complete checkout!");
    });
  });
  </script>
</body>
</html>
