<?php
session_start();
include "db.php";
if (!isset($_SESSION['username'])) {
    die("Please login first.");
}
$username = $_SESSION['username'];

// 🔹 Fetch current balances
$cashBal = 0;
$bankBal = 0;

$cashRes = $conn->query("SELECT current_balance FROM cash_balance WHERE id = 1");
if ($cashRes && $cashRes->num_rows > 0) {
    $cashBal = $cashRes->fetch_assoc()['current_balance'];
}

$bankRes = $conn->query("SELECT current_balance FROM bank_balance WHERE id = 1");
if ($bankRes && $bankRes->num_rows > 0) {
    $bankBal = $bankRes->fetch_assoc()['current_balance'];
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Cash & Bank Management</title>
<style>
    * { box-sizing: border-box; }
    body {
        margin: 0;
        padding: 0;
        font-family: "Segoe UI", Arial, sans-serif;
        background: #f5f7fa;
    }
    .container {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
        align-items: flex-start;
        width: 100%;
        gap: 20px;
        padding: 10px;
    }
    .card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 3px 8px rgba(0,0,0,0.1);
        padding: 15px;
        flex: 1;
        min-width: 300px;
    }
    .balance-box {
        width: 100%;
        background: #007bff;
        color: #fff;
        border-radius: 12px;
        padding: 15px;
        margin: 0 auto 20px auto;
        box-shadow: 0 3px 8px rgba(0,0,0,0.1);
        display: flex;
        justify-content: space-around;
        align-items: center;
        flex-wrap: wrap;
        text-align: center;
    }
    .balance-box div {
        margin: 5px 15px;
    }
    .balance-box h2 {
        font-size: 22px;
        margin: 0;
    }
    .balance-box p {
        font-size: 16px;
        margin: 0;
    }
    h2 {
        margin-top: 0;
        color: #333;
        font-size: 18px;
        border-bottom: 2px solid #007bff;
        display: inline-block;
        margin-bottom: 15px;
    }
    label {
        display: block;
        margin-bottom: 5px;
        font-weight: 600;
        font-size: 14px;
    }
    input, select, textarea {
        width: 100%;
        padding: 8px;
        margin-bottom: 10px;
        border: 1px solid #ccc;
        border-radius: 8px;
        font-size: 14px;
    }
    button {
        padding: 8px 14px;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        color: #fff;
        font-weight: 600;
        transition: 0.2s;
        width: 100%;
    }
    button:hover { opacity: 0.9; }
    .btn-add { background: #28a745; }
    .btn-transfer { background: #007bff; }
    .btn-withdraw { background: #dc3545; }
    .result {
        margin-top: 10px;
        font-size: 14px;
        font-weight: 600;
        color: #333;
    }
    @media (max-width: 768px) {
        .container { flex-direction: column; gap: 15px; }
        .balance-box { flex-direction: column; }
    }
</style>
</head>
<body>

<!-- 🔹 Top Current Balance Section -->
<div class="balance-box">
    <div>
        <h2>💵 Cash Balance</h2>
        <p><b><?php echo number_format($cashBal, 2); ?> Taka</b></p>
    </div>
    <!-- <div>
        <h2>🏦 Bank Balance</h2>
        <p><b><?php echo number_format($bankBal, 2); ?> USD</b></p>
    </div> -->
</div>

<div class="container">

    <!-- 🔹 Add Cash -->
    <div class="card">
        <h2>Add Cash Balance</h2>
        <form id="addCashForm">
            <label>Amount</label>
            <input type="number" step="0.01" name="amount" required>
            <label>Notes</label>
            <textarea name="notes" rows="2" placeholder="Optional notes"></textarea>
            <button type="submit" class="btn-add">Add Cash</button>
        </form>
        <div class="result" id="addCashResult"></div>
    </div>

    <!-- 🔹 Cash to Bank -->
    <div class="card">
        <h2>Cash to Bank Transfer</h2>
        <form id="cashToBankForm">
            <label>Amount</label>
            <input type="number" step="0.01" name="amount" required>
            <label>Bank Name</label>
            <input type="text" name="bank_name" required>
            <label>Notes</label>
            <textarea name="notes" rows="2" placeholder="Optional notes"></textarea>
            <button type="submit" class="btn-transfer">Transfer</button>
        </form>
        <div class="result" id="cashToBankResult"></div>
    </div>

    <!-- 🔹 Withdraw Cash -->
    <div class="card">
        <h2>Cash Withdraw</h2>
        <form id="withdrawForm">
            <label>Amount</label>
            <input type="number" step="0.01" name="amount" required>
            <label>Notes</label>
            <textarea name="notes" rows="2" placeholder="Optional notes"></textarea>
            <button type="submit" class="btn-withdraw">Withdraw</button>
        </form>
        <div class="result" id="withdrawResult"></div>
    </div>

</div>

<script>
async function handleForm(formId, actionType, resultId) {
    const form = document.getElementById(formId);
    const formData = new FormData(form);
    formData.append("action", actionType);

    const response = await fetch("cb_balance_action.php", {
        method: "POST",
        body: formData
    });
    const text = await response.text();
    document.getElementById(resultId).innerHTML = text;

    // Refresh balances after successful update
    loadBalances();
    form.reset();
}

// Reload balances dynamically
async function loadBalances() {
    const res = await fetch("get_balances.php");
    const data = await res.json();
    document.querySelector(".balance-box").innerHTML = `
        <div>
            <h2>💵 Cash Balance</h2>
            <p><b>${parseFloat(data.cash).toFixed(2)} USD</b></p>
        </div>
        <div>
            <h2>🏦 Bank Balance</h2>
            <p><b>${parseFloat(data.bank).toFixed(2)} USD</b></p>
        </div>`;
}

document.getElementById("addCashForm").addEventListener("submit", e => {
    e.preventDefault();
    handleForm("addCashForm", "add_cash", "addCashResult");
});
document.getElementById("cashToBankForm").addEventListener("submit", e => {
    e.preventDefault();
    handleForm("cashToBankForm", "cash_to_bank", "cashToBankResult");
});
document.getElementById("withdrawForm").addEventListener("submit", e => {
    e.preventDefault();
    handleForm("withdrawForm", "withdraw", "withdrawResult");
});
</script>

</body>
</html>
