<?php
// $host = "localhost";
// $user = "root";
// $pass = "";
// $db = "restaurant_pos";

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";
include "db.php";


$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) die("DB Error: " . $conn->connect_error);

// Handle POST actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header("Content-Type: text/plain"); // force plain response
    $action = $_POST['action'] ?? '';

    if ($action === 'add') {
        $name = trim($_POST['name']);
        if ($name === '') {
            echo "error: empty name";
            exit;
        }
        $stmt = $conn->prepare("INSERT INTO categories (name) VALUES (?)");
        $stmt->bind_param("s", $name);
        echo $stmt->execute() ? "success" : "error: " . $stmt->error;
        exit;
    }

    if ($action === 'update') {
        $stmt = $conn->prepare("UPDATE categories SET name=? WHERE id=?");
        $stmt->bind_param("si", $_POST['name'], $_POST['id']);
        echo $stmt->execute() ? "updated" : "error: " . $stmt->error;
        exit;
    }

    if ($action === 'delete') {
        $stmt = $conn->prepare("DELETE FROM categories WHERE id=?");
        $stmt->bind_param("i", $_POST['id']);
        echo $stmt->execute() ? "deleted" : "error: " . $stmt->error;
        exit;
    }
}

// Load categories for table
if (isset($_GET['loadCategories'])) {
    $res = $conn->query("SELECT * FROM categories ORDER BY id DESC");
    while ($row = $res->fetch_assoc()) {
        echo "<tr data-id='{$row['id']}' data-name='{$row['name']}'>
                <td>{$row['id']}</td>
                <td>{$row['name']}</td>
              </tr>";
    }
    exit;
}
?>

<div class="form-container">
    <h2>Manage Categories</h2>
    <form id="catForm">
        <input type="hidden" name="id" id="catId">
        <label>Category Name</label>
        <input type="text" name="name" id="catName" required>
        <button type="button" id="addCatBtn">➕ Add</button>
        <button type="button" id="updateCatBtn" style="display:none;">✏️ Update</button>
        <button type="button" id="deleteCatBtn" style="display:none;">🗑️ Delete</button>
    </form>
    <p id="catMsg"></p>

    <h3>Category List</h3>
    <table border="1" width="100%" id="catTable" cellpadding="5">
        <thead>
            <tr><th>ID</th><th>Name</th></tr>
        </thead>
        <tbody></tbody>
    </table>
</div>

<script>
function attachCategoryHandler() {
    const form = document.getElementById("catForm");
    const addBtn = document.getElementById("addCatBtn");
    const updateBtn = document.getElementById("updateCatBtn");
    const deleteBtn = document.getElementById("deleteCatBtn");
    const msg = document.getElementById("catMsg");
    const table = document.querySelector("#catTable tbody");

    function loadCategories() {
        fetch("category_add.php?loadCategories=1")
            .then(res => res.text())
            .then(data => {
                table.innerHTML = data;
            });
    }
    loadCategories();

    // Add
    addBtn.onclick = () => {
        const fd = new FormData(form);
        fd.append("action", "add");
        console.log("Sending add request:", [...fd]); // debug log
        fetch("category_add.php", { method: "POST", body: fd })
            .then(r => r.text())
            .then(d => {
                console.log("Server response:", d); // debug log
                msg.innerText = d.includes("success") ? "✅ Category Added" : "❌ " + d;
                loadCategories();
                form.reset();
            })
            .catch(err => {
                console.error("Fetch error:", err);
                msg.innerText = "❌ Request failed";
            });
    };

    // Update
    updateBtn.onclick = () => {
        const fd = new FormData(form);
        fd.append("action", "update");
        fetch("category_add.php", { method: "POST", body: fd })
            .then(r => r.text()).then(d => {
                console.log("Update response:", d);
                msg.innerText = d.includes("updated") ? "✅ Updated" : "❌ " + d;
                loadCategories();
                form.reset();
                addBtn.style.display = "inline-block";
                updateBtn.style.display = "none";
                deleteBtn.style.display = "none";
            });
    };

    // Delete
    deleteBtn.onclick = () => {
        if (!confirm("Delete this category?")) return;
        const fd = new FormData(form);
        fd.append("action", "delete");
        fetch("category_add.php", { method: "POST", body: fd })
            .then(r => r.text()).then(d => {
                console.log("Delete response:", d);
                msg.innerText = d.includes("deleted") ? "🗑️ Deleted" : "❌ " + d;
                loadCategories();
                form.reset();
                addBtn.style.display = "inline-block";
                updateBtn.style.display = "none";
                deleteBtn.style.display = "none";
            });
    };

    // Click row to edit
    table.addEventListener("click", e => {
        const tr = e.target.closest("tr");
        if (!tr) return;
        document.getElementById("catId").value = tr.dataset.id;
        document.getElementById("catName").value = tr.dataset.name;
        addBtn.style.display = "none";
        updateBtn.style.display = "inline-block";
        deleteBtn.style.display = "inline-block";
    });
}
attachCategoryHandler();
</script>
