<?php 
include "db.php"; 
session_start(); 

// ✅ Allow only admin
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') { 
    echo "<script>alert('❌ Access denied! Admins only.'); window.location.href='dashboard.php';</script>"; 
    exit; 
} 
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
<style>
body {
    font-family: "Poppins", sans-serif;
    background: #f4f6fa;
    margin: 0;
}
header {
    background: #007bff;
    color: #fff;
    padding: 12px 18px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
}
header h1 {
    margin: 0;
    font-size: 20px;
    display: flex;
    align-items: center;
    gap: 8px;
}
/* Dashboard Grid */
.dashboard {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 15px;
    padding: 15px;
}
/* Cards */
.card {
    background: #fff;
    padding: 15px;
    border-radius: 10px;
    text-align: center;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    transition: 0.25s;
    cursor: pointer;
}
.card:hover {
    transform: scale(1.03);
}
.card h3 {
    color: #007bff;
    font-size: 15px;
    margin-bottom: 6px;
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 6px;
    flex-wrap: wrap;
}
.card p {
    color: #666;
    font-size: 13px;
    margin: 0;
}
/* Content Area */
.content {
    background: #fff;
    margin: 10px 15px 25px;
    padding: 15px;
    border-radius: 10px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}
iframe {
    width: 100%;
    height: 70vh;
    border: none;
    border-radius: 8px;
}
/* Responsive Fixes */
@media (max-width: 600px) {
    header h1 { font-size: 18px; }
    .card { padding: 12px; }
    .card h3 { font-size: 14px; }
    iframe { height: 65vh; }
}
</style>
</head>
<body>
<header>
    <h1><i class="fa-solid fa-user-shield"></i> Admin Dashboard</h1>
</header>

<div class="dashboard">
    <div class="card" onclick="loadPage('user_manage.php')">
        <h3><i class="fa-solid fa-users-gear"></i> Users</h3>
        <p>Manage system users</p>
    </div>

    <div class="card" onclick="loadPage('daily_reports.php')">
        <h3><i class="fa-solid fa-calendar-day"></i> Daily</h3>
        <p>Sales & performance</p>
    </div>

    <div class="card" onclick="loadPage('system_settings.php')">
        <h3><i class="fa-solid fa-gear"></i> Settings</h3>
        <p>System preferences</p>
    </div>

    <div class="card" onclick="loadPage('product_reports.php')">
        <h3><i class="fa-solid fa-chart-column"></i> Reports</h3>
        <p>Product sales data</p>
    </div>

    <!-- ✅ New Customers Button -->
    <div class="card" onclick="loadPage('customer_list.php')">
        <h3><i class="fa-solid fa-address-book"></i> Customers</h3>
        <p>View all customer details</p>
    </div>
    
    <!-- ✅ Transaction Reports Button -->
<div class="card" onclick="loadPage('transactions.php')">
    <h3><i class="fa-solid fa-receipt"></i> Transactions</h3>
    <p>View all cash & bank transactions</p>
</div>

</div>

<div class="content" id="content-area">
    <h3 style="color:#007bff;text-align:center;margin:0;">📂 Select a section to view inside dashboard</h3>
</div>

<script>
function loadPage(page) {
    const content = document.getElementById('content-area');
    content.innerHTML = `<iframe src="${page}" title="${page}"></iframe>`;
    window.scrollTo({ top: content.offsetTop - 10, behavior: 'smooth' });
}
</script>
</body>
</html>
