<?php
session_start();

// ✅ Set your admin password here
$admin_password = "1234";

// ✅ Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    if ($_POST['password'] === $admin_password) {
        $_SESSION['is_admin'] = true;
    } else {
        $error = "❌ Incorrect password!";
    }
}

// ✅ Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: admin.php");
    exit;
}

// ✅ If not logged in, show password form
if (empty($_SESSION['is_admin'])) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Login</title>
  <style>
    body {
      font-family: "Poppins", sans-serif;
      background: linear-gradient(135deg, #007bff, #6610f2);
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    .login-box {
      background: #fff;
      padding: 30px 40px;
      border-radius: 12px;
      box-shadow: 0 6px 20px rgba(0,0,0,0.2);
      text-align: center;
      width: 320px;
    }
    h2 {
      color: #007bff;
      margin-bottom: 20px;
    }
    input[type=password] {
      width: 100%;
      padding: 12px;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 15px;
      margin-bottom: 15px;
      transition: 0.3s;
    }
    input[type=password]:focus {
      border-color: #007bff;
      box-shadow: 0 0 4px rgba(0,123,255,0.3);
      outline: none;
    }
    button {
      width: 100%;
      background: #007bff;
      color: #fff;
      border: none;
      padding: 12px;
      font-size: 15px;
      border-radius: 6px;
      cursor: pointer;
      transition: 0.3s;
    }
    button:hover {
      background: #0056b3;
    }
    .error {
      color: red;
      font-size: 14px;
      margin-bottom: 10px;
    }
  </style>
</head>
<body>
  <div class="login-box">
    <h2>🔐 Admin Access</h2>
    <?php if (!empty($error)) echo "<div class='error'>$error</div>"; ?>
    <form method="POST">
      <input type="password" name="password" placeholder="Enter Admin Password" required>
      <button type="submit">Login</button>
    </form>
  </div>
</body>
</html>
<?php
exit;
}
?>

<!-- ✅ If logged in, show Admin Dashboard -->
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Dashboard</title>
  <style>
    body {
      font-family: "Poppins", sans-serif;
      background: #f4f6fa;
      margin: 0;
    }
    header {
      background: #007bff;
      color: #fff;
      padding: 15px 25px;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    header h1 {
      font-size: 20px;
      margin: 0;
    }
    header a {
      color: #fff;
      text-decoration: none;
      font-weight: bold;
      border: 1px solid #fff;
      padding: 6px 12px;
      border-radius: 6px;
    }
    .dashboard {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
      gap: 20px;
      padding: 40px;
    }
    .card {
      background: #fff;
      padding: 25px;
      border-radius: 12px;
      text-align: center;
      box-shadow: 0 3px 8px rgba(0,0,0,0.1);
      transition: 0.3s;
      cursor: pointer;
    }
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 6px 16px rgba(0,0,0,0.15);
    }
    .card h3 {
      color: #007bff;
      font-size: 18px;
      margin-bottom: 8px;
    }
    .card p {
      color: #666;
      font-size: 14px;
    }
  </style>
</head>
<body>
  <header>
    <h1>Admin Dashboard</h1>
    <a href="?logout=true">Logout</a>
  </header>

  <div class="dashboard">
    <div class="card" onclick="location.href='users_manage.php'">
      <h3>👤 Manage Users</h3>
      <p>Add, edit or remove users</p>
    </div>
    <div class="card" onclick="location.href='daily_reports.php'">
      <h3>📅 Daily Reports</h3>
      <p>View daily sales, purchases, and expenses</p>
    </div>
    <div class="card" onclick="location.href='transactions.php'">
      <h3>💰 Financial Overview</h3>
      <p>See all transactions and balances</p>
    </div>
    <div class="card" onclick="location.href='settings.php'">
      <h3>⚙️ Settings</h3>
      <p>System and security options</p>
    </div>
  </div>
</body>
</html>
