<?php
include "db.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Current Stock</title>

<!-- ✅ Ensures all fetch URLs resolve correctly from any context -->
<base href="https://phizixclub.com/reasturant-pos/">

<style>
body {
  margin:0;
  padding:0;
  font-family:"Poppins",sans-serif;
  background:#f4f6f9;
}
.container {
  width:90%;
  margin:20px auto;
  background:#fff;
  border-radius:10px;
  box-shadow:0 2px 8px rgba(0,0,0,0.1);
  padding:20px;
}
h2 {
  text-align:center;
  background:#007bff;
  color:#fff;
  padding:10px;
  border-radius:6px;
  margin-bottom:20px;
}
table {
  width:100%;
  border-collapse:collapse;
  font-size:14px;
  margin-bottom:30px;
}
table th, table td {
  border:1px solid #ddd;
  padding:8px;
  text-align:center;
}
table th { background:#f1f1f1; }
tr:hover { background:#f9fafb; }
.btn {
  padding:6px 10px;
  border:none;
  border-radius:5px;
  color:#fff;
  cursor:pointer;
  font-size:13px;
}
.action { background:#f59e0b; }

/* Popup modal */
.modal {
  display:none;
  position:fixed;
  top:0; left:0;
  width:100%; height:100%;
  background:rgba(0,0,0,0.5);
  justify-content:center;
  align-items:center;
  z-index:1000;
}
.modal-content {
  background:#fff;
  padding:20px;
  border-radius:10px;
  width:300px;
  text-align:center;
}
.modal-content input {
  width:80%;
  padding:8px;
  margin:10px 0;
  border:1px solid #ccc;
  border-radius:5px;
}
.modal-content button {
  padding:6px 12px;
  border:none;
  border-radius:5px;
  margin:5px;
  color:#fff;
  cursor:pointer;
}
.save { background:#16a34a; }
.cancel { background:#dc2626; }
</style>
</head>
<body>

<div class="container">
  <h2>📦 Current Stock Management</h2>

  <table id="stockTable">
    <thead>
      <tr>
        <th>ID</th>
        <th>Product Name</th>
        <th>Quantity</th>
        <th>Qty Type</th>
        <th>Last Updated</th>
        <th>Action</th>
      </tr>
    </thead>
    <tbody></tbody>
  </table>

  <h2>🍳 Fry Items</h2>
  <table id="fryTable">
    <thead>
      <tr>
        <th>ID</th>
        <th>Product Name</th>
        <th>Fry Qty</th>
        <th>Qty Type</th>
        <th>Date</th>
      </tr>
    </thead>
    <tbody></tbody>
  </table>
</div>

<!-- 🔹 Popup Modal -->
<div class="modal" id="fryModal">
  <div class="modal-content">
    <h3>🍳 Fry Item</h3>
    <p id="modalProductName" style="font-weight:bold;"></p>
    <input type="number" id="fryQty" placeholder="Enter fry quantity">
    <br>
    <button class="save" onclick="saveFry()">Save</button>
    <button class="cancel" onclick="closeModal()">Cancel</button>
  </div>
</div>

<script>
// ✅ Automatically detect correct base URL
const BASE_URL = document.querySelector('base')?.href || '/reasturant-pos/';

let selectedProduct = null;

window.onload = () => {
  loadStock();
  loadFryItems();
};

// ✅ Fetch current stock
async function loadStock() {
  try {
    const res = await fetch(`${BASE_URL}get_stock.php`);
    const stocks = await res.json();
    const tbody = document.querySelector('#stockTable tbody');
    tbody.innerHTML = '';

    if (!stocks || stocks.length === 0) {
      tbody.innerHTML = `<tr><td colspan="6">No stock data found</td></tr>`;
      return;
    }

    stocks.forEach(s => {
      const tr = document.createElement('tr');
      tr.innerHTML = `
        <td>${s.id}</td>
        <td>${s.product_name}</td>
        <td>${s.qty}</td>
        <td>${s.qty_type || '-'}</td>
        <td>${s.updated_at}</td>
        <td><button class="btn action" onclick="openModal(${s.id}, '${s.product_name}', ${s.qty}, '${s.qty_type || ''}')">🍳 Fry</button></td>
      `;
      tbody.appendChild(tr);
    });
  } catch (err) {
    console.error('Error loading stock:', err);
  }
}

// ✅ Open modal
function openModal(id, name, qty, qtyType) {
  selectedProduct = { id, name, qty, qtyType };
  document.getElementById('modalProductName').textContent =
    `${name} (Available: ${qty} ${qtyType})`;
  document.getElementById('fryQty').value = '';
  document.getElementById('fryModal').style.display = 'flex';
}

// ✅ Close modal
function closeModal() {
  document.getElementById('fryModal').style.display = 'none';
  selectedProduct = null;
}

// ✅ Save fry item
async function saveFry() {
  const fryQty = parseFloat(document.getElementById('fryQty').value);
  if (!fryQty || fryQty <= 0) return alert('Please enter valid fry quantity');
  if (fryQty > selectedProduct.qty) return alert('❌ Fry quantity exceeds available stock');

  try {
    const res = await fetch(`${BASE_URL}fry_item_save.php`, {
      method: 'POST',
      headers: {'Content-Type':'application/json'},
      body: JSON.stringify({
        id: selectedProduct.id,
        qty: fryQty
      })
    });

    const result = await res.json();
    alert(result.message);

    if (result.success) {
      closeModal();
      loadStock();
      loadFryItems();
    }
  } catch (err) {
    console.error('Error saving fry item:', err);
    alert('Error: Unable to save fry item.');
  }
}

// ✅ Load fry items
async function loadFryItems() {
  try {
    const res = await fetch(`${BASE_URL}get_fry_items.php`);
    const items = await res.json();
    const tbody = document.querySelector('#fryTable tbody');
    tbody.innerHTML = '';

    if (!items || items.length === 0) {
      tbody.innerHTML = `<tr><td colspan="5">No fry items yet</td></tr>`;
      return;
    }

    items.forEach(i => {
      const tr = document.createElement('tr');
      tr.innerHTML = `
        <td>${i.id}</td>
        <td>${i.product_name}</td>
        <td>${i.qty}</td>
        <td>${i.qty_type || '-'}</td>
        <td>${i.created_at}</td>
      `;
      tbody.appendChild(tr);
    });
  } catch (err) {
    console.error('Error loading fry items:', err);
  }
}
</script>
</body>
</html>
