// Function to load pages dynamically
function loadPage(page) {
  fetch(page)
    .then(res => res.text())
    .then(data => {
      const content = document.getElementById('mainContent');
      content.innerHTML = data;

      // Execute any scripts inside loaded content
      const scripts = content.querySelectorAll('script');
      scripts.forEach(oldScript => {
        const newScript = document.createElement('script');
        if (oldScript.src) {
          newScript.src = oldScript.src;
        } else {
          newScript.textContent = oldScript.textContent;
        }
        document.body.appendChild(newScript);
        oldScript.remove();
      });

      // Attach table click events if it's the dine-in page
      if (page.includes('dinein.php')) {
        attachTableClickEvents();
      }

      // Initialize order page if it's any order page
      if (
        page.includes('order.php') ||
        page.includes('collection.php') ||
        page.includes('delivery.php') ||
        page.includes('waiting.php')
      ) {
        const urlParams = new URLSearchParams(page.split('?')[1]);
        const table = urlParams.get('table') || 0;
        const type =
          urlParams.get('type') ||
          (page.includes('collection.php')
            ? 'collection'
            : page.includes('delivery.php')
            ? 'delivery'
            : page.includes('waiting.php')
            ? 'waiting'
            : 'dinein');

        if (typeof initOrderPage === 'function') {
          initOrderPage(table, type);
        }
      }
    });
}

// Attach click events for dine-in tables dynamically
function attachTableClickEvents() {
  const tables = document.querySelectorAll('.table-box');
  tables.forEach(table => {
    table.onclick = () => {
      if (table.classList.contains('booked')) {
        alert('This table is already booked!');
        return;
      }

      const tableNum = table.dataset.table;

      // Load order page dynamically for the selected table
      loadPage('order.php?table=' + tableNum + '&type=dinein');
    };
  });
}

// New Order modal functionality
const orderModal = document.getElementById('orderModal');
if (orderModal) {
  document.getElementById('newOrderBtn').onclick = e => {
    e.preventDefault();
    orderModal.style.display = 'flex';
  };

  document.getElementById('closeModal').onclick = () =>
    (orderModal.style.display = 'none');

  window.onclick = e => {
    if (e.target == orderModal) orderModal.style.display = 'none';
  };

  function selectOrder(type) {
    orderModal.style.display = 'none';
    if (type === 'dinein') {
      loadPage('dinein.php');
    } else if (type === 'collection') {
      loadPage('collection.php?type=collection');
    } else if (type === 'delivery') {
      loadPage('delivery.php?type=delivery');
    } else if (type === 'waiting') {
      loadPage('waiting.php?type=waiting');
    }
  }

  // Make selectOrder global so inline onclick works
  window.selectOrder = selectOrder;
}
